/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.commons.function;

import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public final class YumiPredicates {
    private static final Predicate<?> ALWAYS_TRUE = new Predicate<Object>(){

        @Override
        public boolean test(Object o) {
            return true;
        }

        public String toString() {
            return "YumiPredicates.alwaysTrue()";
        }
    };
    private static final Predicate<?> ALWAYS_FALSE = new Predicate<Object>(){

        @Override
        public boolean test(Object o) {
            return false;
        }

        public String toString() {
            return "YumiPredicates.alwaysFalse()";
        }
    };

    private YumiPredicates() {
        throw new UnsupportedOperationException("YumiPredicates only contains static definitions.");
    }

    @NotNull
    public static <T> Predicate<T> alwaysTrue() {
        return ALWAYS_TRUE;
    }

    @NotNull
    public static <T> Predicate<T> alwaysFalse() {
        return ALWAYS_FALSE;
    }

    @NotNull
    public static <T> Predicate<T> anyOf() {
        return YumiPredicates.alwaysFalse();
    }

    @NotNull
    public static <T> Predicate<T> anyOf(@NotNull Predicate<T> predicate) {
        return predicate;
    }

    @NotNull
    public static <T> Predicate<T> anyOf(@NotNull Predicate<T> a, @NotNull Predicate<T> b) {
        return a.or(b);
    }

    @SafeVarargs
    @NotNull
    public static <T> Predicate<T> anyOf(Predicate<T> ... predicates) {
        return o -> {
            for (Predicate predicate : predicates) {
                if (!predicate.test(o)) continue;
                return true;
            }
            return false;
        };
    }

    @NotNull
    public static <T> Predicate<T> allOf() {
        return YumiPredicates.alwaysFalse();
    }

    @NotNull
    public static <T> Predicate<T> allOf(@NotNull Predicate<T> predicate) {
        return predicate;
    }

    @NotNull
    public static <T> Predicate<T> allOf(@NotNull Predicate<T> a, @NotNull Predicate<T> b) {
        return a.and(b);
    }

    @SafeVarargs
    @NotNull
    public static <T> Predicate<T> allOf(Predicate<T> ... predicates) {
        return o -> {
            for (Predicate predicate : predicates) {
                if (predicate.test(o)) continue;
                return false;
            }
            return true;
        };
    }
}

